// 
// SVEHLZZPercent (NT7)is Copyright (C) 2012, Sylvain Vervoort <stocata.org>.
// stocata.org/S. Vervoort reserve the right to modify this NinjaScript indicator with each release.
// Release V1.0 October 2012.

#region Using declarations
using System;
using System.ComponentModel;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Chart;
#endregion

// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    /// <summary>
    /// High-Low ZigZag indicator.
    /// </summary>
    [Description("High-Low ZigZag indicator")]
    public class SVEHLZZPercent : Indicator
    {
		// ---------------------------------------------------------------------------------
        #region Variables
		
			private double	ZZPercent		=	5;	
			private int		ATRPeriod		=	5;
			private double	ATRFactor		=	1.5;
			private Color 	zigZagColor		= 	Color.DodgerBlue;
		
			private int 	linewidth	= 1;	
			private int 	trend;		// confirmed trend of current zigzag, 1=up, -1=down
			private int 	lhb;   		// last high bar count of last swing high (bars ago = CurrentBar-lhb)
			private int		uplineid;	// last used up line (name) id
			private int 	llb;   		// last low bar count of last swing low (bars ago = CurrentBar-llb)
			private int		downlineid;	// last used down line name
		    private double 	hh;			// New Higher high
		    private double 	ll;			// New lower low
			private double	HLPivot;	// The high-low pivot level switch

		#endregion

    // ----------------------------------------------------------------------------------------
	/// <summary>
    /// Method used to configure the indicator and only called once before any data is loaded.
    /// </summary>
    protected override void Initialize()
    {
        CalculateOnBarClose	= true;		// Calculate on completed bar only
		AutoScale			= false;	// Auto scaling done by price data
        Overlay				= true;		// Overlay on price data
    }
	
	// --------------------------------------------------------------------------------
    /// <summary>
    /// Method called on each bar update event (incoming tick)
    /// </summary>
    protected override void OnBarUpdate()
    {		
	if (CurrentBar < 1) // minimum 2 bars required
		{
		ll = Low[0];
		hh = High[0];
		llb = lhb = 0;
		return;
		}
	if (CurrentBar < 2) // trend start based on bar 2
		{
		if (High[0] >= hh) 
			{
			hh = High[0];
			lhb = 1;
			trend = 1;
			}
		else 
			{
			ll = Low[0];
			llb = 1;
			trend = -1;
			}
		uplineid = downlineid = CurrentBar;
		}
	
	// ATR factor = 0, only use percent setting
	if (ATRFactor == 0) 
		HLPivot = (ZZPercent*0.01);
	// Zigzag percent = 0, only use ATR
	else if (ZZPercent == 0) 
		HLPivot = ATR(ATRPeriod)[0]/Close[0]*ATRFactor;
	// Use both influences
	else HLPivot = ZZPercent*0.01 + ATR(ATRPeriod)[0]/Close[0]*ATRFactor; 
	
	// --------------------------------------------------------------------------------
	// look for swing points and draw lines
	// trend is up, look for new swing low
	if (trend > 0) 		
		{ 
		if (High[0] >= hh) 
			{	
				// new higher high detected
				hh = High[0];
				lhb = CurrentBar;
				// RemoveDrawObject("uplineid.ToString");
				// Not required, handled by drawing line with the same name id
				DrawLine(uplineid.ToString(), AutoScale, CurrentBar-llb, ll, 
				CurrentBar-lhb, hh, zigZagColor, DashStyle.Solid, linewidth); 
			}
		else if (Low[0] < hh - hh*HLPivot) 
			{	
				// found a swing low
				ll = Low[0];
				llb = CurrentBar;
				downlineid = CurrentBar;
				trend = -1;
				DrawLine(downlineid.ToString(), AutoScale, CurrentBar-lhb, hh, 
				CurrentBar-llb, ll, zigZagColor, DashStyle.Solid, linewidth);
			}
		}
	
	// else trend is down, look for new swing high
	else 
	{
	if (Low[0] <= ll)  
		{
			// new lower low detected
			ll = Low[0];
			llb = CurrentBar;
			// RemoveDrawObject("downlineid.ToString");
			// Not required, handled by drawing line with the same name id
			DrawLine(downlineid.ToString(), AutoScale, CurrentBar-lhb, hh, 
			CurrentBar-llb, ll, zigZagColor, DashStyle.Solid, linewidth);
		}
	else if (High[0] > ll + ll*HLPivot)  
	  {
		// found a swing high
		hh = High[0];
		lhb = CurrentBar;
		uplineid = CurrentBar;
		trend = 1;
		DrawLine(uplineid.ToString(), AutoScale, CurrentBar-llb, ll, 
		CurrentBar-lhb, hh, zigZagColor, DashStyle.Solid, linewidth);
	  }
	}
  }	
	// -----------------------------------------------------------------------------
        #region Properties

        [Description("ZigZag percent influence DEF = 5%, 0 = NO influence")]
        [Category("Parameters")]
        public double __ZigZag__Percentage
        {
            get { return ZZPercent; }
            set { ZZPercent = Math.Max(0, value); }
        }
		
		[Description("ATR Look back Period DEFAULT = 5")]
        [Category("Parameters")]
        public int _ATR__Period
        {
            get { return ATRPeriod; }
            set { ATRPeriod = Math.Max(1, value); }
        }
		
		[Description("ZigZag ATR factor DEF = 1.5, 0 means NO influence")]
        [Category("Parameters")]
        public double _ATR_Factor
        {
            get { return ATRFactor; }
            set { ATRFactor = Math.Max(0, value); }
        }
		
		[Description("Color of the individual zigzag lines DEFAULT = DodgerBlue")]
		[Category("Parameters")]
		public Color ZigZag_Color
		{
			get { return zigZagColor; }
			set { zigZagColor = value; }
		}
		
		[Browsable(false)]
		public string PainttrendcolorSerialize
		{
     		get { return NinjaTrader.Gui.Design.SerializableColor.ToString(zigZagColor); }
     		set { zigZagColor = NinjaTrader.Gui.Design.SerializableColor.FromString(value); }
		}

        #endregion
 }
}

#region NinjaScript generated code. Neither change nor remove.
// This namespace holds all indicators and is required. Do not change it.
namespace NinjaTrader.Indicator
{
    public partial class Indicator : IndicatorBase
    {
        private SVEHLZZPercent[] cacheSVEHLZZPercent = null;

        private static SVEHLZZPercent checkSVEHLZZPercent = new SVEHLZZPercent();

        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        public SVEHLZZPercent SVEHLZZPercent(double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            return SVEHLZZPercent(Input, __ZigZag__Percentage, _ATR__Period, _ATR_Factor, zigZag_Color);
        }

        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        public SVEHLZZPercent SVEHLZZPercent(Data.IDataSeries input, double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            if (cacheSVEHLZZPercent != null)
                for (int idx = 0; idx < cacheSVEHLZZPercent.Length; idx++)
                    if (Math.Abs(cacheSVEHLZZPercent[idx].__ZigZag__Percentage - __ZigZag__Percentage) <= double.Epsilon && cacheSVEHLZZPercent[idx]._ATR__Period == _ATR__Period && Math.Abs(cacheSVEHLZZPercent[idx]._ATR_Factor - _ATR_Factor) <= double.Epsilon && cacheSVEHLZZPercent[idx].ZigZag_Color == zigZag_Color && cacheSVEHLZZPercent[idx].EqualsInput(input))
                        return cacheSVEHLZZPercent[idx];

            lock (checkSVEHLZZPercent)
            {
                checkSVEHLZZPercent.__ZigZag__Percentage = __ZigZag__Percentage;
                __ZigZag__Percentage = checkSVEHLZZPercent.__ZigZag__Percentage;
                checkSVEHLZZPercent._ATR__Period = _ATR__Period;
                _ATR__Period = checkSVEHLZZPercent._ATR__Period;
                checkSVEHLZZPercent._ATR_Factor = _ATR_Factor;
                _ATR_Factor = checkSVEHLZZPercent._ATR_Factor;
                checkSVEHLZZPercent.ZigZag_Color = zigZag_Color;
                zigZag_Color = checkSVEHLZZPercent.ZigZag_Color;

                if (cacheSVEHLZZPercent != null)
                    for (int idx = 0; idx < cacheSVEHLZZPercent.Length; idx++)
                        if (Math.Abs(cacheSVEHLZZPercent[idx].__ZigZag__Percentage - __ZigZag__Percentage) <= double.Epsilon && cacheSVEHLZZPercent[idx]._ATR__Period == _ATR__Period && Math.Abs(cacheSVEHLZZPercent[idx]._ATR_Factor - _ATR_Factor) <= double.Epsilon && cacheSVEHLZZPercent[idx].ZigZag_Color == zigZag_Color && cacheSVEHLZZPercent[idx].EqualsInput(input))
                            return cacheSVEHLZZPercent[idx];

                SVEHLZZPercent indicator = new SVEHLZZPercent();
                indicator.BarsRequired = BarsRequired;
                indicator.CalculateOnBarClose = CalculateOnBarClose;
#if NT7
                indicator.ForceMaximumBarsLookBack256 = ForceMaximumBarsLookBack256;
                indicator.MaximumBarsLookBack = MaximumBarsLookBack;
#endif
                indicator.Input = input;
                indicator.__ZigZag__Percentage = __ZigZag__Percentage;
                indicator._ATR__Period = _ATR__Period;
                indicator._ATR_Factor = _ATR_Factor;
                indicator.ZigZag_Color = zigZag_Color;
                Indicators.Add(indicator);
                indicator.SetUp();

                SVEHLZZPercent[] tmp = new SVEHLZZPercent[cacheSVEHLZZPercent == null ? 1 : cacheSVEHLZZPercent.Length + 1];
                if (cacheSVEHLZZPercent != null)
                    cacheSVEHLZZPercent.CopyTo(tmp, 0);
                tmp[tmp.Length - 1] = indicator;
                cacheSVEHLZZPercent = tmp;
                return indicator;
            }
        }
    }
}

// This namespace holds all market analyzer column definitions and is required. Do not change it.
namespace NinjaTrader.MarketAnalyzer
{
    public partial class Column : ColumnBase
    {
        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SVEHLZZPercent SVEHLZZPercent(double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            return _indicator.SVEHLZZPercent(Input, __ZigZag__Percentage, _ATR__Period, _ATR_Factor, zigZag_Color);
        }

        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        public Indicator.SVEHLZZPercent SVEHLZZPercent(Data.IDataSeries input, double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            return _indicator.SVEHLZZPercent(input, __ZigZag__Percentage, _ATR__Period, _ATR_Factor, zigZag_Color);
        }
    }
}

// This namespace holds all strategies and is required. Do not change it.
namespace NinjaTrader.Strategy
{
    public partial class Strategy : StrategyBase
    {
        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        [Gui.Design.WizardCondition("Indicator")]
        public Indicator.SVEHLZZPercent SVEHLZZPercent(double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            return _indicator.SVEHLZZPercent(Input, __ZigZag__Percentage, _ATR__Period, _ATR_Factor, zigZag_Color);
        }

        /// <summary>
        /// High-Low ZigZag indicator
        /// </summary>
        /// <returns></returns>
        public Indicator.SVEHLZZPercent SVEHLZZPercent(Data.IDataSeries input, double __ZigZag__Percentage, int _ATR__Period, double _ATR_Factor, Color zigZag_Color)
        {
            if (InInitialize && input == null)
                throw new ArgumentException("You only can access an indicator with the default input/bar series from within the 'Initialize()' method");

            return _indicator.SVEHLZZPercent(input, __ZigZag__Percentage, _ATR__Period, _ATR_Factor, zigZag_Color);
        }
    }
}
#endregion
